/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.requestsystem.requestable.deliveryman;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.requestable.deliveryman.AbstractDeliverymanRequestable;
import com.minecolonies.api.util.ReflectionUtils;
import com.minecolonies.api.util.constant.TypeConstants;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import org.jetbrains.annotations.NotNull;

public class Pickup
extends AbstractDeliverymanRequestable {
    private static final Set<TypeToken<?>> TYPE_TOKENS = ReflectionUtils.getSuperClasses(TypeToken.of(Pickup.class)).stream().filter(type -> !type.equals(TypeConstants.OBJECT)).collect(Collectors.toSet());

    public Pickup(int priority) {
        super(priority);
    }

    @NotNull
    public static CompoundNBT serialize(@NotNull IFactoryController controller, Pickup pickup) {
        CompoundNBT compound = new CompoundNBT();
        compound.func_218657_a("Priority", (INBT)controller.serialize(pickup.getPriority()));
        return compound;
    }

    @NotNull
    public static Pickup deserialize(@NotNull IFactoryController controller, @NotNull CompoundNBT compound) {
        int priority = (Integer)controller.deserialize(compound.func_74775_l("Priority"));
        return new Pickup(priority);
    }

    public static void serialize(IFactoryController controller, PacketBuffer buffer, Pickup input) {
        buffer.writeInt(input.getPriority());
    }

    public static Pickup deserialize(IFactoryController controller, PacketBuffer buffer) {
        int priority = buffer.readInt();
        return new Pickup(priority);
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        return o instanceof Pickup;
    }

    public String toString() {
        return "Pickup{priority=" + this.priority + '}';
    }

    @Override
    public Set<TypeToken<?>> getSuperClasses() {
        return TYPE_TOKENS;
    }
}

